USE $(DATA_BASE_NAME);
GO

DELETE from hib.[requesttype]

SET IDENTITY_INSERT  hib.eventtype  ON

--; requestor
Insert into hib.eventtype (id, name, description)
values (1, 'Initiated', 'Initiated Data Access Request')

Insert into hib.eventtype (id, name, description)
values (2, 'Submitted', 'Submitting Data Access Request Packet to NDS')

Insert into hib.eventtype (id, name, description)
values (3, 'Request Amendment Created', 'Creating Amendment')

Insert into hib.eventtype (id, name, description)
values (4, 'Request Submitted with Changes', 'Request Submitted with Changes')

Insert into hib.eventtype (id, name, description)
values (5, 'Closed', 'Data Access Request Closed')

--; intermediate review
Insert into hib.eventtype (id, name, description)
values (6, 'Review Approval', 'Review Approval')

Insert into hib.eventtype (id, name, description)
values (7, 'Review Denied', 'Review Denied')

Insert into hib.eventtype (id, name, description)
values (8, 'Change Requested', 'Change Requested')

Insert into hib.eventtype (id, name, description)
values (9, 'Request Sent for Review', 'Request Sent for Review')
--; overall
Insert into hib.eventtype (id, name, description)
values (10, 'Request Approval', 'Request Approval')
--; all workflows completed
Insert into hib.eventtype (id, name, description)
values (11, 'Request Completed', 'Request Completed')
--; data sources removed, workflow closed
Insert into hib.eventtype (id, name, description)
values (12, 'Workflow Closed', 'Workflow Closed');

Insert into hib.eventtype (id, name, description)
values (13, 'Review Withdrawn', 'Review Withdrawn');

Insert into hib.eventtype (id, name, description)
values (14, 'Additional Reviews Changed by NDS', 'Additional Reviews Changed by NDS');

Insert into hib.eventtype (id, name, description)
values (15, 'Participant Added', 'Participant Added');

Insert into hib.eventtype (id, name, description)
values (16, 'Participant Removed', 'Participant Removed');

SET IDENTITY_INSERT  hib.eventtype  OFF